#!/bin/bash
#
# Copyright (C) 2013-2016, Intel Corporation. All rights reserved.
#
# The source code, information and material ("Material") contained herein is owned by Intel Corporation
# or its suppliers or licensors, and title to such Material remains with Intel Corporation or its suppliers
# or licensors. The Material contains proprietary information of Intel or its suppliers and licensors.
# The Material is protected by worldwide copyright laws and treaty provisions. No part of the Material may be
# used, copied, reproduced, modified, published, uploaded, posted, transmitted, distributed or disclosed in
# any way without Intel's prior express written permission. No license under any patent, copyright or other
# intellectual property rights in the Material is granted to or conferred upon you, either expressly, by implication,
# inducement, estoppel or otherwise. Any license under such intellectual property rights must be express and approved
# by Intel in writing.
#
# Unless otherwise agreed by Intel in writing, you may not remove or alter this notice or any other notice embedded
# in Materials by Intel or Intel’s suppliers or licensors in any way.
#

SCRIPT_NAME=$(basename ${0})
SCRIPT_DIR=$(cd $(dirname ${0}) 2>/dev/null; pwd)

PNAME="Intel(R) Software Manager"

if [ ! -w "$SCRIPT_DIR" ]; then
    echo -e "Super-user or \"root\" privileges are required in order to continue.\n"
    echo -n "Please enter \"root\" "
    exec su -c "/bin/bash '${SCRIPT_DIR}/${SCRIPT_NAME}' $@"
    echo
    return 1
fi

silent=0
to_delete=0

if echo $@ | grep "\-\-silent" 2>/dev/null 1>&2; then
    silent=1
    to_delete=1
fi

if [ $silent -eq 0 ]; then
    echo -n "Do you really want to uninstall ${PNAME}? ( Yes/No ) [ No ]: "
    read answer
    if echo $(echo $answer | tr "[[:upper:]]" "[[:lower:]]") | grep -e "^y$" -e "^yes$" -e "^yep$" 2>/dev/null 1>&2; then
        to_delete=1
    fi
fi

if [ $to_delete -eq 1 ]; then
    rm -rf ${SCRIPT_DIR} 1>/dev/null 2>&1
    if [ $? -eq 0 ]; then
        echo "   Successfully uninstalled."
    else
        echo "   Uninstall failed."
    fi
else
    echo "Uninstall cancelled..."
fi

exit $?

